//
// An NSThread wrapper that compensates for 10.4
// deficiencies
//

#import <Cocoa/Cocoa.h>

@protocol SYThread<NSObject>
- (id)initWithTarget:(id)target selector:(SEL)selector object:(id)argument;

- (bool)isExecuting;
- (bool)isFinished;

- (bool)isCancelled;
- (void)cancel;

- (void)start;

- (NSThread*) thread;
- (NSMutableDictionary *)threadDictionary;
@end


@interface SYThread : NSObject<SYThread>
{
    id volatile impl;
}

+ (id<SYThread>)currentThread;
+ (void)detachNewThreadSelector:(SEL)selector toTarget:(id)target withObject:(id)argument;

@end